//
//  Resize.metal
//  EffectMgrMetal
//
//  Created by WS on 2021/5/26.
//  Copyright © 2021 WS. All rights reserved.
//

#include <metal_stdlib>
using namespace metal;

constexpr sampler s_resize(address::clamp_to_zero,
                    filter::linear,
                    compare_func::less);

kernel void Resize(texture2d<float, access::sample> in [[texture(0)]],
                   texture2d<float, access::write> out [[texture(1)]],
                   constant int *inW [[buffer(0)]],
                   constant int *inH [[buffer(1)]],
                   constant int *outW [[buffer(2)]],
                   constant int *outH [[buffer(3)]],
                   uint2 gid [[thread_position_in_grid]])
{
    out.write(in.sample(s_resize, float2(gid.x * 1.0f / *outW, gid.y * 1.0f / *outH)), gid);
}
